//
//  TodoItemDetail.swift
//  Do It
//
//  Created by Jim Dovey on 5/20/20.
//  Copyright © 2020 Pragmatic Programmers. All rights reserved.
//

import SwiftUI

struct TodoItemDetail: View {
    let item: TodoItem
    
    var body: some View {
        // START:DetailBody
        VStack(alignment: .leading) {
            Rectangle()
                .fill(item.list.color.uiColor)
                .edgesIgnoringSafeArea(.top)
                .frame(height: 210)
                .overlay(TitleOverlay(item: item))
            
            if item.notes != nil {
                Text(item.notes!)
                    .padding(.horizontal)
            }
            
            Spacer()
        }
        .navigationBarTitle("", displayMode: .inline)
        // END:DetailBody
    }
    
    // START:TitleOverlayBase
    private struct TitleOverlay: View {
        let item: TodoItem
        // END:TitleOverlayBase
        
        // START:Gradient
        var gradient: LinearGradient {
            LinearGradient(
                gradient: Gradient(colors: [ //<label id="code.gradient.colors" />
                    Color.black.opacity(0.6),
                    Color.black.opacity(0),
                ]),
                startPoint: .bottom, //<label id="code.gradient.start" />
                endPoint: .init(x: 0.5, y: 0.1)) //<label id="code.gradient.end" />
        }
        // END:Gradient
        
        // START:OverlayBody
        var body: some View {
            ZStack(alignment: .bottomLeading) {
                Rectangle().fill(gradient)
                // <literal:elide> ... </literal:elide>
                // END:OverlayBody
                // START:TitleStack
                VStack(alignment: .leading, spacing: 8) {
                    Text(item.title)
                        .font(.title)
                        .bold()
                    // <literal:elide> ... </literal:elide>
                    // END:TitleStack
                    // START:PriorityDateStack
                    HStack(alignment: .firstTextBaseline) {
                        // <literal:elide> ... </literal:elide>
                        // END:PriorityDateStack
                        // START:PriorityContent
                        Text("Priority: ") + Text(item.priority.rawValue.capitalized).bold()
                        // END:PriorityContent
                        // START:DateContent
                        Spacer()
                        if item.date != nil {
                            Text("\(item.date!, formatter: Formatters.mediumDate)")
                        }
                        else {
                            Text("No Due Date")
                        }
                        // END:DateContent
                        // START:PriorityDateStack
                    }
                    .font(.subheadline)
                    // END:PriorityDateStack
                    // START:TitleStack
                }
                .foregroundColor(.white)
                .padding()
                // END:TitleStack
                // START:OverlayBody
            }
        }
        // END:OverlayBody
        // START:TitleOverlayBase
    }
    // END:TitleOverlayBase
}

struct TodoItemDetail_Previews: PreviewProvider {
    static var previews: some View {
        TodoItemDetail(item: defaultTodoItems[0])
    }
}
